#ifndef __SERVER_H
#define __SERVER_H

//=======================================================================
//		File:	SERVER.H
//		Date:	4-1-97
//		Name:
//
//		Desc:	This header contains various public defines, type
//				definitions, external declaration, and function
//				prototypes for the main server window.
//
//		Copyright (C) 1997 by Microsoft Corporation.  All rights reserved.
//=======================================================================

//=======================================================================
//		Include Files
//=======================================================================

//=======================================================================
//		Public Defines
//=======================================================================

//----  Icon IDs  ----
#define ICON_JEWELS				0
#define ICON_MONEY				1
#define ICON_ART				2
#define ICON_HOMES				3
#define ICON_PEOPLE				4
#define ICON_PLANES				5
#define ICON_CLOTHING			6

#define NUM_ICONS				7

#define	NO_ICON_CLICKED			-1
#define	NO_ICON_SEL_ANCHOR		-1

//----  Control IDs  ----
#define ID_BUTTON				NUM_ICONS
#define ID_STATUSBAR			(NUM_ICONS + 1)



//=======================================================================
//		Type Definitions
//=======================================================================

typedef struct tag_ICON_INFO
{
	RECT		rcBounds;			// bounding rectangle of icon
    HICON       hIcon;				// handle of the icon
	BOOL		bIsSelected;		// whether or not the icon is selected
	BOOL		bIsSelAnchor;		// whether or not the icon is the selection anchor
	BOOL		bHasFocus;			// whether or not the icon has the input focus
} ICON_INFO;



//=======================================================================
//		External Declarations
//=======================================================================

extern	ICON_INFO	g_rgIcons[NUM_ICONS];	// array of icon information elements



//=======================================================================
//		Public Function Prototypes
//=======================================================================

int		HasAnIconBeenClicked( POINT pt );
void	UpdateIconSelection( int nIcon, ULONG fwKeys );
void	FocusAndAnchorIcon( int nIcon );
void	SelectIconOnly( int nIcon );

//----  Public function for access to the button  ----
BOOL	Button_HasFocus( void );
BOOL	Button_IsPushed( void );
BOOL	Button_IsEqualHWND( HWND hWnd );
void	Button_Click( void );
void	Button_SetFocus( void );
BOOL	Button_GetWindowRect( LPRECT lpRect );

//----  Public function for access to the status bar  ----
BOOL	StatusBar_IsEqualHWND( HWND hWnd );
BOOL	StatusBar_GetWindowRect( LPRECT lpRect );



#endif /* __SERVER_H */


//----  End of SERVER.H  ----