
/******************************************************************************\
*       This is a part of the Microsoft Source Code Samples. 
*       Copyright (C) 1993 Microsoft Corporation.
*       All rights reserved. 
*       This source code is only intended as a supplement to 
*       Microsoft Development Tools and/or WinHelp documentation.
*       See these sources for detailed information regarding the 
*       Microsoft samples programs.
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|   hook.h    - Windows message spy application                               |
|                                                                             |
\*----------------------------------------------------------------------------*/

#define PUBLIC
#if !DBG
#define PRIVATE static
#else
#define PRIVATE
#endif

// special hwnds for the hooks to recognize
#define HWND_ALL  ((HWND)0xffffffff)
#define HWND_NULL ((HWND)0L)

#define SPYAPPNAME      "OAC Spy"
#define SPYCLASSNAME    "OAC Spy Class"
#define HOOKWINDOWNAME  "SpyHookWindow"
#define HOOKWINDOWCLASS "SpyHookClass"

#define MYSTR char
#define MYBSTR *char

#define OBJNAME_LEN 64
#define HELPDESCRIPTION_LEN 64
#define ROLES_LEN 64
#define CHILDREN_LEN 64
#define SEL_LEN 64
#define FOCUS_LEN 64
#define PARENT_LEN 64
#define VALUE_LEN 64
#define DEFACTION_LEN 64
#define SHORTCUT_LEN 64
#define STATE_LEN 64

typedef struct
{
	long xLeft;
	long yTop;
	long xWidth;
	long yHight;
        BSTR bstrObjName;
        BSTR bstrHelpDescription;
        BSTR bstrRoles;
	IDispatch FAR* pdispChildren;
	IDispatch FAR* pdispKeyboardFocus;
	IDispatch FAR* pdispSelection;

        char szObjName[OBJNAME_LEN];
        char szHelp[HELPDESCRIPTION_LEN]; 
        char szRole[ROLES_LEN];
        char szChildren[CHILDREN_LEN];
        char szSel[SEL_LEN];
        char szFocus[FOCUS_LEN];
        char szParent[PARENT_LEN];
        char szValue[VALUE_LEN];
        char szDefAction[DEFACTION_LEN];
        char szShortcut[SHORTCUT_LEN];
        char szState[STATE_LEN];

        HRESULT hr;
} OACOBJINFO;

//
// Structure that contains the spy message data sent from the hook
// to the spy app to display.  The hwnd is sent using wParam of
// the WM_COPYDATA message, and the message number is in the dwData
// field of the COPYDATASTRUCT.  This structure allows the wParam,
// lParam and any optional extra data to be passed across.
//
typedef struct
{
    WPARAM wParam;
    LPARAM lParam;
    LONG x;
    LONG y;
    OACOBJINFO oi;
    BYTE ExtraData[64];
} SPYMSGDATA, *PSPYMSGDATA;


LRESULT CALLBACK SpyGetMsgProc(INT hc, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK SpyCallWndProc(INT hc, WPARAM wParam, LPARAM lParam);

HRESULT GetObjectInfo(LPUNKNOWN punk, LONG index, OACOBJINFO *poi);
HRESULT oacGetObjectInfo(IAccessible*, LONG, OACOBJINFO*);
HRESULT dispGetObjectInfo(IDispatch FAR*, OACOBJINFO*);
void BstrToStr(LPSTR str, BSTR bstr);
VOID PrintDebug(LPTSTR fmt,  ...);
BOOL IsHResultError(HRESULT hr, LPSTR szText);
void HResultText(LPSTR, HRESULT);

#define WMSTR_GETOI TEXT("WM_GETOI")
