/*************************************************************************
	Project:    Babble
    Module:     actions.cpp

    Author:     Charles Oppermann (ChuckOp)   
    Date:       23 October 1996
    
    Notes:      Performs specific actions

    Copyright (C) 1996 by Microsoft Corporation.  All rights reserved.
    See bottom of file for disclaimer
    
    History:

*************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>

#include <oleacc.h>

#include "babble.h"
#include "tts.h"        // Bring in TTS support
#include "getprop.h"
#include "actions.h"



/*************************************************************************
    Function:   SpeakDescription
    Purpose:    
    Inputs:     
    Returns:    
    History:
*************************************************************************/
void SpeakDescription(int nOption)
{
    int cchBuf = 256;
    TCHAR tszDesc[256];
    VARIANT varChild;
    IAccessible* pIAcc;
    HRESULT hr;
    POINT ptMouse;

    // Important to init variants
    VariantInit(&varChild);

    GetCursorPos(&ptMouse);
    
    hr = AccessibleObjectFromPoint(ptMouse, &pIAcc, &varChild);
    
    // Check to see if we got a valid pointer
    if (SUCCEEDED(hr))
        {
        OBJINFO objCurrent;

        objCurrent.hwnd = WindowFromPoint(ptMouse);
        objCurrent.plObj = (long*)pIAcc;
        objCurrent.varChild = varChild;
    
        if (!GetObjectDescription(&objCurrent, tszDesc, cchBuf))
            {
            SpeakString(tszDesc);
            }
        
        if (pIAcc)
            pIAcc->Release();
        
        }
    return;
}


void SpeakHelp(int nOption)
{
}

void SpeakName(int nOption)
{
    int cchBuf = 128;
    TCHAR tszName[128];
    TCHAR tszSpeak[1024];
    VARIANT varChild;
    IAccessible* pIAcc;
    HRESULT hr;
    POINT ptMouse;

    // Important to init variants
    VariantInit(&varChild);

    GetCursorPos(&ptMouse);
    
    hr = AccessibleObjectFromPoint(ptMouse, &pIAcc, &varChild);
    
    // Check to see if we got a valid pointer
    if (SUCCEEDED(hr))
        {
        OBJINFO objCurrent;

        objCurrent.hwnd = WindowFromPoint(ptMouse);
        objCurrent.plObj = (long*)pIAcc;
        objCurrent.varChild = varChild;
    
        if (!GetObjectName(&objCurrent, tszName, cchBuf))
            {
            wsprintf(tszSpeak, "Name is %s", tszName);

            SpeakString(tszSpeak);
            }
        if (pIAcc)
            pIAcc->Release();
        
        }
    return;
}


void SpeakDefaultAction(int nOption)
    {
    }

void SpeakValue(int nOption)
{
    int cchBuf = 256;
    TCHAR tszValue[256];
    VARIANT varChild;
    IAccessible* pIAcc;
    HRESULT hr;
    POINT ptMouse;

    // Important to init variants
    VariantInit(&varChild);

    GetCursorPos(&ptMouse);
    
    hr = AccessibleObjectFromPoint(ptMouse, &pIAcc, &varChild);
    
    // Check to see if we got a valid pointer
    if (SUCCEEDED(hr))
        {
        OBJINFO objCurrent;

        objCurrent.hwnd = WindowFromPoint(ptMouse);
        objCurrent.plObj = (long*)pIAcc;
        objCurrent.varChild = varChild;
    
        if (!GetObjectValue(&objCurrent, tszValue, cchBuf))
            {
            SpeakString(tszValue);
            }
        if (pIAcc)
            pIAcc->Release();
        }
    return;

}

void DoDefaultAction(int nOption)
    {}

void SpeakState(int nOption)
    {
    }

void SpeakKeyboardShortCut(int nOption)
    {
    }

void SetFocusToObject(int nOption)
    {
    }
void SetSelectionToObject(int nOption)
    {
    }

void Navigate(int nOption)
    {
    }

/*************************************************************************
    THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
    AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
    NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
    ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
    CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
    MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
    LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
    FOREGOING LIMITATION MAY NOT APPLY.
*************************************************************************/