// --------------------------------------------------------------------------
//
//  WINDDI.H
//
//  Hooking mechanism to see all screen output.
//
//  NOTE:  You must include GDIDEFS.INC from the DDK to get the definitions
//  of the structures used in this file.
//
// --------------------------------------------------------------------------

#ifndef _WINDDI_
#define _WINDDI_

#if !defined(_WINDDI_)
#define WINDDIAPI   DECLSPEC_IMPORT
#else
#define WINDDIAPI
#endif

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus


//
// Forward declarations of structures passed as various DDI parameters
//

typedef struct tagPDEVICE FAR*      LPPDEVICE;
typedef struct tagDRAWESCAPE FAR*   LPDRAWESCAPE;
typedef struct tagDISPVALMODE FAR*  LPDISPVALMODE;
typedef struct tagCOLORINFO FAR*    LPCOLORINFO;
typedef struct tagPPEN FAR*         LPPPEN;
typedef struct tagPBRUSH FAR*       LPPBRUSH;
typedef struct tagFONTINFO FAR*     LPFONTINFO;
typedef struct tagTEXTXFORM FAR*    LPTEXTXFORM;
typedef struct tagDEVMODE FAR*      LPDEVMODE;


typedef struct tagDDI FAR* HDDI;

//
// Classes of DDI hooks
//
#define DDIHOOK_MIN             0x0000
#define DDIHOOK_RECORDER        0x0001
#define DDIHOOK_REMOTE          0x0002
#define DDIHOOK_FONTS           0x0003
#define DDIHOOK_MAGNIFIER       0x0004
#define DDIHOOK_MAX             0x0005

//
// DDIs
//
typedef UINT    DDITYPE;
typedef LPVOID  LPDDIPARAMS;

typedef DWORD (CALLBACK* DDIHOOKPROC)(HDDI, LONG, DDITYPE, LPDDIPARAMS);


WINDDIAPI
HDDI
WINAPI
SetDDIHook(
    HDC         hdcHook,
    HMODULE     hModCode,
    LONG        lPrivateData,
    UINT        hookClass,
    DDIHOOKPROC lpfnDdiHook
);


WINDDIAPI
BOOL
WINAPI
UnhookDDIHook(
    HDDI        hddi
);


WINDDIAPI
DWORD
WINAPI
CallNextDDI(
    HDDI            hddi,
    DDITYPE         ddiType,
    LPDDIPARAMS     lpDdiParams
);


//
// The DDIs you can hook currently:
//
#define DDI_BITBLT              0x0000
typedef struct tagBITBLT_DDIPARAMS
{
    LPDRAWMODE      lpDrawMode;
    LPPBRUSH        lpPBrush;
    DWORD           dwRop;
    int             cySrc;
    int             cxSrc;
    int             ySrc;
    int             xSrc;
    LPPDEVICE       lpDevSrc;
    int             yDst;
    int             xDst;
    LPPDEVICE       lpDevDst;
}
BITBLT_DDIPARAMS, FAR* LPBITBLT_DDIPARAMS;


#define DDI_COLORINFO           0x0001
typedef struct tagCOLORINFO_DDIPARAMS
{
    LPVOID          lpPhysBits;
    DWORD           rgbColor;
    LPPDEVICE       lpDev;
}
COLORINFO_DDIPARAMS, FAR* LPCOLORINFO_DDIPARAMS;


#define DDI_CONTROL             0x0002
typedef struct tagCONTROL_DDIPARAMS
{
    LPVOID          lpOutData;
    LPVOID          lpInData;
    UINT            uCode;
    LPPDEVICE       lpDev;
}
CONTROL_DDIPARAMS, FAR* LPCONTROL_DDIPARAMS;


#define DDI_DISABLE             0x0003
typedef struct tagDISABLE_DDIPARAMS
{
    LPPDEVICE       lpDev;
}
DISABLE_DDIPARAMS, FAR* LPDISABLE_DDIPARAMS;


#define DDI_ENABLE              0x0004
typedef struct tagENABLE_DDIPARAMS
{
    LPVOID          lpDriverInfo;
    LPSTR           lpOutputFile;
    LPSTR           lpDeviceType;
    UINT            uStyle;
    LPPDEVICE       lpDev;
}
ENABLE_DDIPARAMS, FAR* LPENABLE_DDIPARAMS;


#define DDI_ENUMDEVICEFONTS     0x0005
typedef struct tagENUMDEVICEFONTS_DDIPARAMS
{
    LPVOID          lpClientData;
    FARPROC         lpfnCallback;
    LPSTR           lpszFaceName;
    LPPDEVICE       lpDev;
}
ENUMDEVICEFONTS_DDIPARAMS, FAR* LPENUMDEVICEFONTS_DDIPARAMS;


#define DDI_ENUMOBJECTS         0x0006
typedef struct tagENUMOBJECTS_DDIPARAMS
{
    LPVOID          lpClientData;
    FARPROC         lpfnCallback;
    UINT            uStyle;
    LPPDEVICE       lpDev;
}
ENUMOBJECTS_DDIPARAMS, FAR* LPENUMOBJECTS_DDIPARAMS;


#define DDI_OUTPUT              0x0007
typedef struct tagOUTPUT_DDIPARAMS
{
    LPRECT          lprcClip;
    LPDRAWMODE      lpDrawMode;
    LPPBRUSH        lpBrush;
    LPPPEN          lpPen;
    LPPOINT         lpPoints;
    UINT            uPointCount;
    UINT            uStyle;
    LPPDEVICE       lpDev;
}
OUTPUT_DDIPARAMS, FAR* LPOUTPUT_DDIPARAMS;


#define DDI_PIXEL               0x0008
typedef struct tagPIXEL_DDIPARAMS
{
    LPDRAWMODE      lpDrawMode;
    DWORD           rgbColor;
    int             y;
    int             x;
    LPPDEVICE       lpDev;
}
PIXEL_DDIPARAMS, FAR* LPPIXEL_DDIPARAMS;


#define DDI_REALIZEOBJECT       0x0009
typedef struct tagREALIZEOBJECT_DDIPARAMS
{
    LPTEXTXFORM     lpTextTransform;
    LPVOID          lpOutObject;
    LPVOID          lpInObject;
    UINT            uObjectId;
    LPPDEVICE       lpDev;
}
REALIZEOBJECT_DDIPARAMS, FAR* LPREALIZEOBJECT_DDIPARAMS;


#define DDI_STRINGBLT           0x000A
typedef struct tagSTRINGBLT_DDIPARAMS
{
    LPTEXTXFORM     lpTextTransform;
    LPDRAWMODE      lpDrawMode;
    LPFONTINFO      lpFont;
    UINT            cchText;
    LPSTR           lpszText;
    LPRECT          lprcClip;
    int             yStart;
    int             xStart;
    LPPDEVICE       lpDev;
}
STRINGBLT_DDIPARAMS, FAR* LPSTRINGBLT_DDIPARAMS;


#define DDI_SCANLEFTRIGHT       0x000B
typedef struct taSCANLEFTRIGHT_DDIPARAMS
{
    UINT            uStyle;
    DWORD           rgbSearch;
    int             yStart;
    int             xStart;
    LPPDEVICE       lpDev;
}
SCANLEFTRIGHT_DDIPARAMS, FAR* LPSCANLEFTRIGHT_DDIPARAMS;


#define DDI_DEVICEMODE          0x000C
typedef struct tagDEVICEMODE_DDIPARAMS
{
    LPSTR           lpFileName;
    LPSTR           lpDeviceName;
    HMODULE         hmod;
    HWND            hwnd;
}
DEVICEMODE_DDIPARAMS, FAR* LPDEVICEMODE_DDIPARAMS;


#define DDI_EXTTEXTOUT          0x000D
typedef struct tagEXTTEXTOUT_DDIPARAMS
{
    UINT            uOptions;
    LPRECT          lprcOpaque;
    LPINT           lpCharWidths;
    LPTEXTXFORM     lpTextTransform;
    LPDRAWMODE      lpDrawMode;
    LPFONTINFO      lpFont;
    int             cchText;
    LPSTR           lpszText;
    LPRECT          lprcClip;
    int             yStart;
    int             xStart;
    LPPDEVICE       lpDev;
}
EXTTEXTOUT_DDIPARAMS, FAR* LPEXTTEXTOUT_DDIPARAMS;


#define DDI_GETCHARWIDTH        0x000E
typedef struct tagGETCHARWIDTH_DDIPARAMS
{
    LPTEXTXFORM     lpTextTransform;
    LPDRAWMODE      lpDrawMode;
    LPFONTINFO      lpFont;
    UINT            ichLast;
    UINT            ichFirst;
    LPVOID          lpWidths;
    LPPDEVICE       lpDev;
}
GETCHARWIDTH_DDIPARAMS, FAR* LPGETCHARWIDTH_DDIPARAMS;


#define DDI_DEVICEBITMAP        0x000F
typedef struct tagDEVICEBITMAP_DDIPARAMS
{
    LPVOID          lpBits;
    LPVOID          lpBitmap;
    UINT            uCommand;
    LPPDEVICE       lpDev;
}
DEVICEBITMAP_DDIPARAMS, FAR* LPDEVICEBITMAP_DDIPARAMS;


#define DDI_FASTBORDER          0x0010
typedef struct tagFASTBORDER_DDIPARAMS
{
    LPRECT          lprcClip;
    LPDRAWMODE      lpDrawMode;
    LPPBRUSH        lpPBrush;
    LPPDEVICE       lpDev;
    DWORD           dwRop;
    UINT            cyBorder;
    UINT            cxBorder;
    LPRECT          lprcFrame;
}
FASTBORDER_DDIPARAMS, FAR* LPFASTBORDER_DDIPARAMS;


#define DDI_SETATTRIBUTE        0x0011
typedef struct tagSETATTRIBUTE_DDIPARAMS
{
    DWORD           dwAttribute;
    UINT            uIndex;
    UINT            uStateNum;
    LPPDEVICE       lpDev;
}
SETATTRIBUTE_DDIPARAMS, FAR* LPSETATTRIBUTE_DDIPARAMS;


#define DDI_DIBBLT              0x0012
typedef struct tagDIBBLT_DDIPARAMS
{
    LPCOLORINFO     lpColorInfo;
    LPDRAWMODE      lpDrawMode;
    LPBITMAPINFO    lpBitmapInfo;
    LPVOID          lpBits;
    UINT            cScans;
    UINT            iScan;
    BOOL            fGet;
    LPPDEVICE       lpDev;
}
DIBBLT_DDIPARAMS, FAR* LPDIBBLT_DDIPARAMS;


#define DDI_CREATEDIBITMAP      0x0013
typedef struct tagCREATEDIBITMAP_DDIPARAMS
{
    DWORD       dwDummyNotReallyHere;
}
CREATEDIBITMAP_DDIPARAMS, FAR* LPCREATEDIBITMAP_DDIPARAMS;


#define DDI_DIBTODEVICE         0x0014
typedef struct tagDIBTODEVICE_DDIPARAMS
{
    LPCOLORINFO     lpColorInfo;
    LPBITMAPINFO    lpBitmapInfo;
    LPVOID          lpBits;
    LPDRAWMODE      lpDrawMode;
    LPRECT          lprcClip;
    UINT            cScans;
    UINT            iScan;
    int             yStart;
    int             xStart;
    LPPDEVICE       lpDev;
}
DIBTODEVICE_DDIPARAMS, FAR* LPDIBTODEVICE_DDIPARAMS;


#define DDI_SETPALETTE          0x0015
#define DDI_GETPALETTE          0x0016
typedef struct tagGETSETPALETTE_DDIPARAMS
{
    LPPDEVICE       lpDevice;
    LPVOID          lpPalette;
    UINT            cEntries;
    UINT            iEntryStart;
}
GETSETPALETTE_DDIPARAMS, FAR* LPGETSETPALETTE_DDIPARAMS;


#define DDI_SETPALETTETRANSLATE 0x0017
#define DDI_GETPALETTETRANSLATE 0x0018
typedef struct tagGETSETPALETTETRANSLATE_DDIPARAMS
{
    LPPDEVICE       lpDevice;
    LPVOID          lpColorTranslateTable;
}
GETSETPALETTETRANSLATE_DDIPARAMS, FAR* LPGETSETPALETTETRANSLATE_DDIPARAMS;


#define DDI_UPDATECOLORS        0x0019
typedef struct tagUPDATECOLORS_DDIPARAMS
{
    LPPDEVICE       lpDevice;
    LPCOLORINFO     lpColorInfo;
    int             cyUpdate;
    int             cxUpdate;
    int             yStart;
    int             xStart;
}
UPDATECOLORS_DDIPARAMS, FAR* LPUPDATECOLORS_DDIPARAMS;


#define DDI_STRETCHBLT          0x001A
typedef struct tagSTRETCHBLT_DDIPARAMS
{
    LPRECT          lprcClip;
    LPDRAWMODE      lpDrawMode;
    LPPBRUSH        lpPBrush;
    DWORD           dwRop;
    int             cySrc;
    int             cxSrc;
    int             ySrc;
    int             xSrc;
    LPPDEVICE       lpDevSrc;
    int             cyDst;
    int             cxDst;
    int             yDst;
    int             xDst;
    LPPDEVICE       lpDevDst;
}
STRETCHBLT_DDIPARAMS, FAR* LPSTRETCHBLT_DDIPARAMS;


#define DDI_STRETCHDIBITS       0x001B
typedef struct tagSTRETCHDIBITS_DDIPARAMS
{
    LPRECT          lprcClip;
    LPDRAWMODE      lpDrawMode;
    LPPBRUSH        lpPBrush;
    DWORD           dwRop;
    LPCOLORINFO     lpColorInfo;
    LPBITMAPINFO    lpBitmapInfo;
    LPVOID          lpBits;
    int             cySrc;
    int             cxSrc;
    int             ySrc;
    int             xSrc;
    int             cyDst;
    int             cxDst;
    int             yDst;
    int             xDst;
    BOOL            fGet;
    LPPDEVICE       lpDevDst;
}
STRETCHDIBITS_DDIPARAMS, FAR* LPSTRETCHDIBITS_DDIPARAMS;


#define DDI_SELECTBITMAP        0x001C
typedef struct tagSELECTBITMAP_DDIPARAMS
{
    DWORD           dwFlags;
    LPVOID          lpBitmap;
    LPVOID          lpPrevBitmap;
    LPPDEVICE       lpDev;
}
SELECTBITMAP_DDIPARAMS, FAR* LPSELECTBITMAP_DDIPARAMS;


#define DDI_BITMAPBITS          0x001D
typedef struct tagBITMAPBITS_DDIPARAMS
{
    LPVOID          lpBitmap;
    DWORD           dwByteCount;
    DWORD           dwFlags;
    LPPDEVICE       lpDev;
}
BITMAPBITS_DDIPARAMS, FAR* LPBITMAPBITS_DDIPARAMS;


#define DDI_REENABLE            0x001E
typedef struct tagREENABLE_DDIPARAMS
{
    LPGDIINFO       lpGdiInfo;
    LPPDEVICE       lpDev;
}
REENABLE_DDIPARAMS, FAR* LPREENABLE_DDIPARAMS;


#define DDI_GAMMARAMP           0x001F
typedef struct tagGAMMARAMP_DDIPARAMS
{
    LPVOID          lpGammaRamp;
    BOOL            fSet;
    LPPDEVICE       lpDev;
}
GAMMARAMP_DDIPARAMS, FAR* LPGAMMARAMP_DDIPARAMS;


#define DDI_ICMCOLORINFO        0x0020
typedef struct tagICMCOLORINFO_DDIPARAMS
{
    LPVOID          lpColorTransform;
    LPVOID          lpColor;
    DWORD           rgbColor;
    LPPDEVICE       lpDev;
}
ICMCOLORINFO_DDIPARAMS, FAR* LPICMCOLORINFO_DDIPARAMS;


#define DDI_DRAWESCAPE          0x0021
typedef struct tagDRAWESCAPE_DDIPARAMS
{
    LPDRAWESCAPE    lpDrawEscape;
}
DRAWESCAPE_DDIPARAMS, FAR* LPDRAWESCAPE_DDIPARAMS;


#define DDI_MAX                 0x0022


#ifdef __cplusplus
}
#endif  // __cplusplus

#endif  // !_WINDDI_
