#ifndef __ACCESS_H
#define __ACCESS_H

//=======================================================================
//		File:	ACCESS.H
//		Date:	4-1-97
//		Name:
//
//		Desc:	This header contains the definition of the CAccClient
//				class.  This class is used by the server application
//				defined in SERVER.CPP to provide Accessible support
//				for the client area (and all its children) of the main
//				window.
//
//		Copyright (C) 1997 by Microsoft Corporation.  All rights reserved.
//=======================================================================

//=======================================================================
//		Include Files
//=======================================================================

#include <windows.h>
#include <winable.h>
#include <ole2.h>
#include <oleacc.h>
#include "enumvar.h"



//=======================================================================
//		Public Defines
//=======================================================================

#define	NO_ICON_SELECTED		-1



//=======================================================================
//		Class Definitions
//=======================================================================

//-----------------------------------------------------------------------
//		CAccClient Class Definition
//-----------------------------------------------------------------------

class CAccClient : public IAccessible
{
public:
	//--------------------------------
	//	IUnknown interface methods
	//--------------------------------

	STDMETHODIMP			QueryInterface( REFIID riid, void** ppv );
	STDMETHODIMP_(ULONG)	AddRef( void );
	STDMETHODIMP_(ULONG)	Release( void );


	//--------------------------------
	//	IDispatch interface methods
	//--------------------------------

	STDMETHODIMP		GetTypeInfoCount( UINT* pctinfo );
	STDMETHODIMP		GetTypeInfo( UINT itinfo, LCID lcid, ITypeInfo** pptinfo );
	STDMETHODIMP		GetIDsOfNames( REFIID riid,
						               OLECHAR** rgszNames,
						               UINT cNames,
						               LCID lcid,
						               DISPID* rgdispid );
	STDMETHODIMP		Invoke( DISPID dispidMember,
						        REFIID riid,
						        LCID lcid,
						        WORD wFlags,
						        DISPPARAMS* pdispparams,
						        VARIANT* pvarResult,
						        EXCEPINFO* pexcepinfo,
						        UINT* puArgErr );


	//--------------------------------
	//	IAccessible interface methods
	//--------------------------------

	STDMETHODIMP		get_accParent( IDispatch ** ppdispParent );
	STDMETHODIMP		get_accChildCount( long* pChildCount );
	STDMETHODIMP		get_accChild( VARIANT varChild,
						              IDispatch ** ppdispChild );
	STDMETHODIMP		get_accName( VARIANT varChild, BSTR* pszName );
	STDMETHODIMP		get_accValue( VARIANT varChild, BSTR* pszValue );
	STDMETHODIMP		get_accDescription( VARIANT varChild,
						                    BSTR* pszDescription );
	STDMETHODIMP		get_accRole( VARIANT varChild, VARIANT *pvarRole );
	STDMETHODIMP		get_accState( VARIANT varChild, VARIANT *pvarState );
	STDMETHODIMP		get_accHelp( VARIANT varChild, BSTR* pszHelp );
	STDMETHODIMP		get_accHelpTopic( BSTR* pszHelpFile,
						                  VARIANT varChild,
						                  long* pidTopic );
	STDMETHODIMP		get_accKeyboardShortcut( VARIANT varChild,
						                         BSTR* pszKeyboardShortcut );
	STDMETHODIMP		get_accFocus( VARIANT * pvarFocusChild );
	STDMETHODIMP		get_accSelection( VARIANT * pvarSelectedChildren );
	STDMETHODIMP		get_accDefaultAction( VARIANT varChild,
						                      BSTR* pszDefaultAction );
	STDMETHODIMP		accSelect( long flagsSel, VARIANT varChild );
	STDMETHODIMP		accLocation( long* pxLt,
						             long* pyTp,
									 long* pcxWd,
									 long* pcyHt,
									 VARIANT varChild );
	STDMETHODIMP		accNavigate( long navDir,
						             VARIANT varStart,
									 VARIANT * pVarEndUpAt );
	STDMETHODIMP		accHitTest( long xLeft,
						            long yTop,
									VARIANT * pvarChildAtPoint );
	STDMETHODIMP		accDoDefaultAction( VARIANT varChild );
	STDMETHODIMP		put_accName( VARIANT varChild, BSTR szName );
	STDMETHODIMP		put_accValue( VARIANT varChild, BSTR pszValue );


	//--------------------------------
	//	Constructors and Destructors
	//--------------------------------

	CAccClient( void );
	~CAccClient( void );


	//--------------------------------
	//	Initialization methods
	//--------------------------------

	HRESULT				Initialize( HWND hwnd, HINSTANCE hInst );


	//--------------------------------
	//	Public helper methods
	//--------------------------------

	void				SendWinEventForChild( DWORD dwEvt, int nChildOffset );


protected:
	//--------------------------------
	//	Implementation helper methods
	//--------------------------------

	STDMETHODIMP	CreateVarEnumOfAllChildren( CEnumVariant** pcenum );
	STDMETHODIMP	CreateVarEnumOfSelIcons( CEnumVariant** pcenum,
					                         int nNumSelIcons );
	BOOL			IsValidChildVariant( VARIANT * pVar );
	HRESULT			HrLoadString( int iStr, BSTR * psz );
	int				GetOffsetFromChildID( long lChildID );
	long			GetChildIDFromOffset( int nOffset );


	//--------------------------------
	//	Data members
	//--------------------------------

	IAccessible *	m_pDefAccClient;
	ITypeInfo *		m_pTypeInfo;
	HWND			m_hWnd;
	HINSTANCE		m_hInst;
};



#endif  /* __ACCESS_H */



//----  End of ACCESS.H  ----