
/******************************************************************************\
*       This is a part of the Microsoft Source Code Samples. 
*       Copyright (C) 1993 Microsoft Corporation.
*       All rights reserved. 
*       This source code is only intended as a supplement to 
*       Microsoft Development Tools and/or WinHelp documentation.
*       See these sources for detailed information regarding the 
*       Microsoft samples programs.
\******************************************************************************/

/*****************************************************************************\
*
* Module: oacspy.h
*
*   Main include file for the Windows debugging OAC Spy SDK applet.
*
\*****************************************************************************/

#ifdef _DEBUG
#ifndef DEBUG
#define DEBUG
#endif
#endif

#define WINABLE
#include <windows.h>
#include <ole2.h>
#include <oleacc.h>
#include <winable.h>
#include "dialogs.h"
#include "hook.h"


#define MAXSTRING                   MAX_PATH

#define LINES_MAX                   250         // Max lines allowed in window.


//
// Message Table Flags
//
#define MTF_SELECTED                0x00000001

#define MTF_TYPE_MOUSE              0x00010000
#define MTF_TYPE_DDE                0x00020000
#define MTF_TYPE_CLIP               0x00040000
#define MTF_TYPE_NC                 0x00080000
#define MTF_TYPE_KEYBD              0x00100000
#define MTF_TYPE_LB                 0x00200000
#define MTF_TYPE_BM                 0x00400000
#define MTF_TYPE_STM                0x00800000
#define MTF_TYPE_CB                 0x01000000
#define MTF_TYPE_EM                 0x02000000


//
// Menu ids.
//

#define MENU_SPY_SELECTWINDOW       1000
#define MENU_SPY_ABOUT              1001
#define MENU_SPY_EXIT               1002
#define MENU_SPY_README             1003
#define MENU_SPY_OBJECTSEL          1004

#define MENU_EDIT_CUT               1100
#define MENU_EDIT_COPY              1101
#define MENU_EDIT_CLEAR             1102

#define MENU_OPTIONS_MESSAGES       1200
#define MENU_OPTIONS_FONT           1201
#define MENU_OPTIONS_OUTPUT         1202
#define MENU_OPTIONS_ONTOP          1203
#define MENU_OPTIONS_CURSORTRACK    1204
#define MENU_OPTIONS_SCREENREADER   1205

#define MENU_START                  1300
#define MENU_STOP                   1301

//
// Position of the top level menu items.
//
#define MENUPOS_OPTIONS             1
#define MENUPOS_STARTSTOP           2


//
// Prototype for the Message Decode functions.
//
typedef VOID (*LPFNDECODE)(HWND, UINT, PSPYMSGDATA);


//
// The Message Description Table structure that describes each message
// that Spy understands.
//
typedef struct
{
    LPTSTR pszMsg;
    UINT msg;
    UINT Flags;
    LPFNDECODE pfnDecode;
} MSGDESC, *PMSGDESC;


//
// The message group structure.  A table of these structures describes
// each different group of messages that can be selected/deselected
// for spying on using the Messages dialog.
//
typedef struct
{
    INT idCheckBox;
    DWORD flMask;
    INT cMsgs;
    INT cUseCount;
} MSGGROUP, *PMSGGROUP;


extern HINSTANCE ghInst;
extern HWND ghwndSpyApp;
extern HWND ghwndPrintf;
extern HANDLE ghHookThread;
extern HWND ghwndSpyHook;
extern HWND ghwndSpyingOn;              // The window we are spying on.
extern HFONT ghfontPrintf;
extern INT gnLines;
extern BOOL gfSpyOn;
extern BOOL gfSpyAll;
extern BOOL gfOutputWin;
extern BOOL gfOutputCom1;
extern BOOL gfOutputFile;
extern HFILE gfhFile;
extern CHAR gszFile[];
extern INT gcxBorder;
extern INT gcyBorder;
extern BOOL gfMsgsUser;
extern BOOL gfMsgsUnknown;
extern CHAR gszAppName[];
extern WINDOWPLACEMENT gwndpl;

extern MSGDESC gaMsgs[];
extern INT gcMessages;
extern MSGGROUP gaMsgGroup[];
extern INT gcMsgGroups;
extern INT gaiSelected[];
extern INT gaiSelected2[];


extern BOOL gfAlwaysOnTop;
extern BOOL gfCursorTrack;
extern OACOBJINFO grgoiObjectSel[5];
extern HWND ghdlgSelectWindow, ghdlgObjectSel;
extern UINT WM_GETOI;          
extern RECT grectCursor;

#include "spyfuncs.h"
#include "wprintf.h"

#define INDEX_KEYBOARDFOCUS 0
#define INDEX_SELECTION 1
#define INDEX_CARET 2
#define INDEX_SEMENTICCHANGE 3
#define INDEX_ALERT 4

void UpdateSelectWindowDlg(OACOBJINFO *);
void UpdateObjectSelDlg(int, OACOBJINFO*);

void CALLBACK
ObjectSelNotifyProc
(
    HWINEVENTHOOK  hEvent,
    DWORD   event,
    HWND    hwndMsg,
    LONG    idObject,
    LONG    idChild,
    DWORD   idThread,
    DWORD   dwmsEventTime
);

