/*************************************************************************
	Project:    Babble
    Module:     getprop.cpp

    Author:     Charles Oppermann (ChuckOp)   
    Date:       24 October 1996
    
    Notes:      Gets Object Information

    Copyright (C) 1996 by Microsoft Corporation.  All rights reserved.
    See bottom of file for disclaimer
    
    History:

*************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <winerror.h>

#include <oleacc.h>

#include "babble.h"
#include "tts.h"        // Bring in TTS support
#include "getprop.h"

/*************************************************************************
    Function:   GetObjectName
    Purpose:    
    Inputs:     
    Returns:    
    History:
*************************************************************************/
DWORD GetObjectName(LPOBJINFO poiObj,LPSTR lpszBuf, int cchBuf)
{
    DWORD dwRetVal;
    BSTR  bszName;
    IAccessible* pIAcc;
    long* pl;

    bszName = NULL;

    // Get the object out of the struct
    pl = poiObj->plObj;

    pIAcc =(IAccessible*)pl;

    // Get the object's name
    pIAcc->get_accName(poiObj->varChild, &bszName);
    
    // Did we get name string?
    if (bszName)
    {
        // Convert from Unicode to ANSI
        if (WideCharToMultiByte(CP_ACP,     // code page 
                                0,          // performance and mapping flags 
                                bszName,    // address of wide-character string 
                                -1,         // number of characters in string 
                                lpszBuf,    // address of buffer for new string 
                                cchBuf,     // size of buffer 
                                NULL,       // address of default for unmappable characters  
                                NULL))
            dwRetVal = NO_ERROR;
        else
            dwRetVal = GetLastError();

        SysFreeString(bszName);
        return(dwRetVal);
    }
        
    
    // Need general failure handling routine
    MessageBeep(MB_ICONEXCLAMATION);
    
    return(ERROR_INVALID_FUNCTION);
}

/*************************************************************************
    Function:   GetObjectDescription
    Purpose:    
    Inputs:     
    Returns:    
    History:
*************************************************************************/
DWORD GetObjectDescription(LPOBJINFO poiObj,LPSTR lpszBuf, int cchBuf)
{
    DWORD dwRetVal;
    BSTR  bszDesc;
    IAccessible* pIAcc;
    long* pl;

    bszDesc = NULL;

    // Get the object out of the struct
    pl = poiObj->plObj;

    pIAcc =(IAccessible*)pl;

    // Get the object's name
    pIAcc->get_accDescription(poiObj->varChild, &bszDesc);
    
    // Did we get name string?
    if (bszDesc)
    {
        // Convert from Unicode to ANSI
        if (WideCharToMultiByte(CP_ACP,     // code page 
                                0,          // performance and mapping flags 
                                bszDesc,    // address of wide-character string 
                                -1,         // number of characters in string 
                                lpszBuf,    // address of buffer for new string 
                                cchBuf,     // size of buffer 
                                NULL,       // address of default for unmappable characters  
                                NULL))
            dwRetVal = NO_ERROR;
        else
            dwRetVal = GetLastError();

        SysFreeString(bszDesc);
        return(dwRetVal);
    }
        
    
    // Need general failure handling routine
    MessageBeep(MB_ICONEXCLAMATION);
    
    return(ERROR_INVALID_FUNCTION);
}

/*************************************************************************
    Function:   GetObjectValue
    Purpose:    
    Inputs:     
    Returns:    
    History:
*************************************************************************/
DWORD GetObjectValue(LPOBJINFO poiObj, LPSTR lpszBuf, int cchBuf)
{
    DWORD dwRetVal;
    BSTR  bszValue;
    IAccessible* pIAcc;
    long* pl;

    bszValue = NULL;

    // Get the object out of the struct
    pl = poiObj->plObj;

    pIAcc =(IAccessible*)pl;

    // Get the object's name
    pIAcc->get_accValue(poiObj->varChild, &bszValue);
    
    // Did we get name string?
    if (bszValue)
    {
        // Convert from Unicode to ANSI
        if (WideCharToMultiByte(CP_ACP,     // code page 
                                0,          // performance and mapping flags 
                                bszValue,   // address of wide-character string 
                                -1,         // number of characters in string 
                                lpszBuf,    // address of buffer for new string 
                                cchBuf,     // size of buffer 
                                NULL,       // address of default for unmappable characters  
                                NULL))
            dwRetVal = NO_ERROR;
        else
            dwRetVal = GetLastError();

        SysFreeString(bszValue);
        return(dwRetVal);
    }
        
    // Need general failure handling routine
    MessageBeep(MB_ICONEXCLAMATION);
    
    return(ERROR_INVALID_FUNCTION);
}

/*************************************************************************
    THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
    AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
    NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
    ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
    CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
    MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
    LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
    FOREGOING LIMITATION MAY NOT APPLY.
*************************************************************************/
