/*************************************************************************
	Project:    Babble
    Module:     babble.c

    Author:     Charles Oppermann (ChuckOp)   
    Date:       26 September 1996
    
    Notes:      Contains main application initalization code

    Copyright (C) 1996 by Microsoft Corporation.  All rights reserved.
    See bottom of file for disclaimer
    
    History:

*************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <oleacc.h>

#include "babble.h"
#include "resource.h"
#include "tts.h"        // Bring in TTS support
#include "winevent.h"  // Bring in Active Accessibility support
#include "actions.h"
#include "babhook\keys.h"

// Hot keys (+ CTRL & SHIFT):
#define CKEYS_HOT 14

HOTK rgHotKeys[CKEYS_HOT] =
{   //Key       Function            Parameter
    { VK_F1,    SpeakHelp,              0},  
    { VK_F2,    SpeakName,              0},  
    { VK_F3,    SpeakValue,             0},  
    { VK_F4,    SpeakDescription,       0},  
    { VK_F5,    SpeakState,             0},  
    { VK_F6,    SpeakKeyboardShortCut,  0},
    { VK_F7,    SetFocusToObject,       0},  
    { VK_F8,    SetSelectionToObject,   0},  
    { VK_F9,    SpeakDefaultAction,     0},  
    { VK_F10,   DoDefaultAction,        0},
    { VK_F11,   Navigate,               NAV_PREV},
    { VK_F12,   Navigate,               NAV_NEXT},
    { VK_NEXT,  Navigate,               NAV_DOWN},
    { VK_PRIOR, Navigate,               NAV_UP}
};

// Local functions
BOOL CALLBACK DialogProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL InitApp(HINSTANCE hInstance, int nCmdShow);
BOOL UnInitApp(void);

// Local varibles

/*************************************************************************
    Function:   WinMain
    Purpose:    Entry point of application
    Inputs:     
    Returns:    Int containing the return value of the app.
    History:
*************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
    // Initialization
    if (InitApp(hInstance, nCmdShow))
        {
        // Bring up the dialog box
        DialogBox (hInstance, MAKEINTRESOURCE(IDD_ABOUT),NULL, (DLGPROC)DialogProc);
        }

   return 0;
}

/*************************************************************************
    Function:   DialogProc
    Purpose:    Handles messages for the About Box dialog
    Inputs:     
    Returns:
    History:
*************************************************************************/
BOOL CALLBACK DialogProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

    switch (uMsg)
        {
        case WM_INITDIALOG:
            // Init global hot keys (need to do here because we need a hwnd)
            InitKeys(hwnd);

            // Speak a start up string
            SpeakString("Babble is running.");
            break;

        case WM_BABBLEKEY:
            // Look up the key and dispatch it
            
            int ihotk;
            for (ihotk = 0; ihotk < CKEYS_HOT; ihotk++)
                {
                if (rgHotKeys[ihotk].keyVal == wParam)
                    {
                    // Call the function
                    (*rgHotKeys[ihotk].lFunction)(rgHotKeys[ihotk].nOption);
                    return(TRUE);
                    }
                }
            break;
            
        case WM_COMMAND:
            switch (LOWORD(wParam))
                {
                case IDC_EXIT:
                    SpeakString("Leaving Babble.");
                    EndDialog (hwnd, IDCANCEL);
                    return(TRUE);
                }
            break;
        };

    return(FALSE);  // didn't handle
}

/*************************************************************************
    Function:   InitApp
    Purpose:    Initalizes the application.
    Inputs:     HINSTANCE hInstance - Handle to the current instance
                INT nCmdShow - how to present the window
    Returns:    TRUE if app initalized without error.
    History:
*************************************************************************/
BOOL InitApp(HINSTANCE hInstance, int nCmdShow)
{
    // Create the TTS Objects
    if (InitTTS())
        {
        // Initialize Microsoft Active Accessibility
        if (InitMSAA())
            {
            return TRUE;
            }
        }
    // Something failed, exit false
    return FALSE;
}

/*************************************************************************
    Function:   UnInitApp
    Purpose:    Shuts down the application
    Inputs:     none
    Returns:    TRUE if app uninitalized properly
    History:
*************************************************************************/
BOOL UnInitApp(void)
{
    if (UnInitTTS())
        {
        if (UnInitMSAA())
            {
            UninitKeys();
            return TRUE;
            }
        }
    return FALSE;
}

/*************************************************************************
    THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
    AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
    NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
    ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
    CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
    MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
    LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
    FOREGOING LIMITATION MAY NOT APPLY.
*************************************************************************/