/*************************************************************************
	Project:    Babble
    Module:     keys.cpp

    Author:     Charles Oppermann (ChuckOp)   
    Date:       22 October 1996
    
    Notes:      Controls processing of global hot-keys

    Copyright (C) 1996 by Microsoft Corporation.  All rights reserved.
    See bottom of file for disclaimer
    
    History:

*************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>

#include "keys.h"
#include "..\babble.h"

// Global Variables
#pragma data_seg(".sdata")
HWND    g_hwndBabble = NULL;
HHOOK   hhookKey = NULL;
#pragma data_seg()

// Local functions
LRESULT CALLBACK KeyboardProc(int code, WPARAM wParam, LPARAM lParam);

// Local varibles


/*************************************************************************
    Function:   InitKeys
    Purpose:    Set up processing for global hot keys
    Inputs:     HWND hwnd
    Returns:    BOOL - TRUE if successful
    History:
*************************************************************************/
BOOL InitKeys(HWND hwnd)
{
    HMODULE hModSelf;

    // If someone else has a hook installed, fail.
    if (g_hwndBabble)
        return(FALSE);
    
    // Save off the hwnd to send messages to
    g_hwndBabble = hwnd;

    // Get the module handle for this DLL
    hModSelf = GetModuleHandle("babhook.dll");

    if(!hModSelf)
        return(FALSE);
    
    // Set up the global keyboard hook
    hhookKey = SetWindowsHookEx(WH_KEYBOARD, // What kind of hook
                                KeyboardProc,// Proc to send to
                                hModSelf,    // Our Module
                                0);          // For all threads

    // Return TRUE|FALSE based on result
    return(hhookKey != NULL);
}

/*************************************************************************
    Function:   UninitKeys
    Purpose:    Deinstall the hooks
    Inputs:     void
    Returns:    BOOL - TRUE if successful
    History:
*************************************************************************/
BOOL UninitKeys(void)
{
    // Reset
    g_hwndBabble = NULL;
    
    // Check to see that the hook was installed
    if (hhookKey)
        {
        // It was, unhook it
        UnhookWindowsHookEx(hhookKey);

        // Reinit the variable
        hhookKey = NULL;

        return(TRUE);
        }
    // The hook wasn't installed, wierd - let's exit wierd    
    return(FALSE);
}


/*************************************************************************
    Function:   KeyboardProc
    Purpose:    Gets called for keys hit
    Inputs:     void
    Returns:    BOOL - TRUE if successful
    History:
*************************************************************************/
LRESULT CALLBACK KeyboardProc(int code,	        // hook code
                              WPARAM wParam,    // virtual-key code
                              LPARAM lParam)    // keystroke-message information
{
    if (code == HC_ACTION)
        {

        // If this is a key up, or the Alt key is down, bail out now.
        if (!(lParam & 0xA0000000))
            {
            // If the Shift or Control key isn't down, bail out
            if (!((GetKeyState(VK_SHIFT) >= 0) || (GetKeyState(VK_CONTROL) >= 0)))
                {
                OutputDebugString("Sending key");
                PostMessage(g_hwndBabble, WM_BABBLEKEY, wParam, lParam);
                }
            }
        }
        
    return(CallNextHookEx(hhookKey, code, wParam, lParam));
}

// --------------------------------------------------------------------------
//
//  Entry point:  DllMain()
//
//  We do this to avoid pulling in the CRT.
//
// --------------------------------------------------------------------------
BOOL WINAPI
DllMain(HINSTANCE hinst, DWORD dwReason, LPVOID pvReserved)
{
    return(TRUE);
}

/*************************************************************************
    Function:   
    Purpose:    
    Inputs:     
    Returns:    
    History:
*************************************************************************/

/*************************************************************************
    THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
    AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
    NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
    ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
    CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
    MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
    LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
    FOREGOING LIMITATION MAY NOT APPLY.
*************************************************************************/
