// --------------------------------------------------------------------------
//
//  EVENT.H
//
//  Resource IDs and APIs used by ACCEVENT
//
// --------------------------------------------------------------------------

// This is the message we post.
#define     WM_ADDEVENT         WM_APP

STDAPI_(HANDLE) InstallEventHook(HWND hwndPostTo,BOOL fInContext);

STDAPI_(void)   SetEventFilter(UINT flags);

// Flags for SetEventFilter

// Objects
#define SEF_WINDOW_OBJECTS  0x00000001
#define SEF_CURSOR_OBJECTS  0x00000002
#define SEF_CARET_OBJECTS   0x00000004
#define SEF_SOUND_OBJECTS   0x00000008
#define SEF_ALERT_OBJECTS   0x00000010
#define SEF_TRACKING        0x0000001F

// Events
#define SEF_CREATION        0x00000100
#define SEF_STATE           0x00000200
#define SEF_DESCRIPTION     0x00000400
#define SEF_LOCATION        0x00000800
#define SEF_FOCUSSEL        0x00001000
#define SEF_OTHER           0x00002000
#define SEF_MODE_TRACK      0x00004000

// Other flags
#define SEF_USEINVOKE       0x80000000


STDAPI_(void)   DoFakeEvent(UINT);

#define FAKE_EVENT_SYSTEM_DEFACTION         0x800
#define FAKE_EVENT_SYSTEM_FOCUS             0x801
#define FAKE_EVENT_SYSTEM_SELECTION         0x802
#define FAKE_EVENT_SYSTEM_SELECTIONADD      0x803
#define FAKE_EVENT_SYSTEM_SELECTIONREMOVE   0x804
#define FAKE_EVENT_SYSTEM_UNDERTHECURSOR    0x805


#ifndef NOTEVENTDLL

//
// Macros
//
#define ARRAYSIZE(rg)       (sizeof(rg) / sizeof(rg[0]))
#define MYSUCCEEDED(hr)     (SUCCEEDED(hr) || ((hr) == DISP_E_MEMBERNOTFOUND))

//
// Functions
//
UINT GetObjectName(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectDescription(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectBasic(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectValue(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectRole(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectState(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectLocation(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectShortcut(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectDefAction(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectHelp(IAccessible*, VARIANT*, LPTSTR, UINT);
UINT GetObjectParent(IAccessible*, VARIANT*, LPTSTR, UINT);

UINT ObjectProc(HWINEVENTHOOK, DWORD, HWND, LONG, LONG, DWORD, LPTSTR, UINT);

extern UINT grfTrack;

#endif
