Option Strict Off
Option Explicit On
Friend Class frmAlphaDvr
	Inherits System.Windows.Forms.Form
	
	Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Integer)
	
	Private Session As Object
	
	' Protocols
	Const FT_XMODEM As Short = 1
	Const FT_YMODEM As Short = 2
	Const FT_ZMODEM As Short = 3
	Const FT_KERMIT As Short = 4
	Const FT_XMODEM1K As Short = 5
	
	' Transfer states
	Const TRS_NORMAL As Short = 0
	Const TRS_SENDING As Short = 1
	Const TRS_RECEIVING As Short = 2
	Const TRS_SUCCESS As Short = 3
	Const TRS_FAILURE As Short = 4
	
	Private Sub cmdConnect_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdConnect.Click
        Session.Connect()
	End Sub
	
	Private Sub cmdCreateObject_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCreateObject.Click
        Session = Nothing
		Session = CreateObject("Alpha.RS232")
        Session.ShowWindow(1)
		Session.OpenSessionFile("c:\tmp\modem.cfm")
		Call Session.Connect()
		Call Session.Dial("")
	End Sub
	
	Private Sub cmdCreateSSH_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCreateSSH.Click
        Session = Nothing
		Session = CreateObject("Alpha.SSH")
		Session.NewSession()
	End Sub
	
	Private Sub cmdCreateTelnetObject_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCreateTelnetObject.Click
        Session = Nothing
		Session = CreateObject("Alpha.Telnet")
        Session.NewSession()
	End Sub
	
	Private Sub cmdDisconnect_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdDisconnect.Click
        Session.Disconnect()
	End Sub
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		If Not Session Is Nothing Then
            Session.CloseApp()
			'UPGRADE_NOTE: Object Session may not be destroyed until it is garbage collected. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6E35BFF6-CD74-4B09-9689-3E1A43DF8969"'
			Session = Nothing
		End If
		Me.Close()
	End Sub
	
	Private Sub cmdGetBaudRate_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetBaudRate.Click
		stsStatusBar.Text = "Baud rate is " & Session.GetBaudRate
	End Sub
	
	Private Sub cmdGetCurrentPort_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetCurrentPort.Click
		stsStatusBar.Text = "Current port is " & Session.GetCurrentPort
	End Sub
	
	Private Sub cmdGetFlowControl_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetFlowControl.Click
		Dim intTmp As Short
		'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
		Dim str_Renamed As String
		intTmp = Session.GetFlowControl
        If intTmp = 1 Then
            str_Renamed = "No Flow Control"
        End If
        If intTmp And 1 Then
            str_Renamed = str_Renamed & "DTRDSR " & vbCrLf
        End If
        If intTmp And 2 Then
            str_Renamed = str_Renamed & "RTSCTS " & vbCrLf
        End If
        If intTmp And 4 Then
            str_Renamed = str_Renamed & "XONXOFF " & vbCrLf
        End If
        stsStatusBar.Text = str_Renamed
    End Sub

    Private Sub cmdGetHost_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetHost.Click
        stsStatusBar.Text = "Host name is " & Session.GetHost
    End Sub

    Private Sub cmdGetPortName_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetPortName.Click
        Dim intLoop As Short
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        For intLoop = 1 To Session.GetPortCount
            str_Renamed = str_Renamed & Session.GetPortName(intLoop) & " "
        Next
        stsStatusBar.Text = "Available ports are " & str_Renamed
    End Sub

    Private Sub cmdGetRow_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetRow.Click
        stsStatusBar.Text = "Cursor position is " & (Session.GetCursorRow & ", " & Session.GetCursorColumn)
    End Sub

    Private Sub cmdGetTele_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdGetTele.Click
        stsStatusBar.Text = "Telephone number is " & Session.GetDial
    End Sub

    Private Sub cmdHangup_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdHangup.Click
        Session.Hangup()
    End Sub

    Private Sub cmdHide_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdHide.Click
        Session.HideWindow(1)
    End Sub

    Private Sub cmdNewSession_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdNewSession.Click
        Session = Nothing
        Session = CreateObject("Alpha.RS232")
        Session.NewSession()
    End Sub

    Private Sub cmdOpenSession_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdOpenSession.Click
        Session = Nothing
        Session = GetObject("c:\tmp\modem.cfm", "Alpha.RS232")
        Session.ShowWindow(1)
        Session.Display("Executing cmdOpenSession_Click() Event\r\n")
        Exit Sub

        Dim intState As Short
        Do
            intState = Session.GetDialState()
        Loop While intState <> 3 And intState <> 4

        If intState <> 3 Then
            stsStatusBar.Text = "Uunable to connect"
            Exit Sub
        End If

        Do
            intState = Session.GetLoginState()
        Loop While intState <> 6 And intState <> 7

        If intState = 6 Then
            stsStatusBar.Text = "Login successful"
        Else
            stsStatusBar.Text = "Login not successful"
            Exit Sub
        End If

    End Sub

    Private Sub cmdOpenSessionSSH_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdOpenSessionSSH.Click
        Session = Nothing
        Session = CreateObject("Alpha.SSH")
        Session.OpenSessionFile("c:\ssh.cfs")
        Call Session.Connect()
        Session.ShowWindow(1)
    End Sub

    Private Sub cmdReadScreen_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdReadScreen.Click
        stsStatusBar.Text = "Seven characters at 1,1 are " & Session.ReadScreen(1, 1, 7)
    End Sub

    Private Sub cmdReceiveFile_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdReceiveFile.Click
        Dim strMsg As String
        Dim strTmp As String
        Dim strLocalDir As String
        Dim intProtocol As Short

        ' Determine file to send
        strLocalDir = InputBox("Local directory to place file:")

        ' Determine protocol
        strMsg = "1 = XMODEM" & vbCrLf & "3 = ZMODEM" & vbCrLf & "5 = XMODEM1K" & vbCrLf & vbCrLf & "Select a protocol:"
        strTmp = InputBox(strMsg)
        intProtocol = Val(strTmp)

        Call Session.ReceiveFile("", strLocalDir, intProtocol, True)
        Do
            Select Case Session.GetTransferState
                Case TRS_NORMAL
                    stsStatusBar.Text = "Unable to transfer " & strLocalDir
                Case TRS_SENDING
                    stsStatusBar.Text = "Sending " & strLocalDir
                Case TRS_RECEIVING
                    stsStatusBar.Text = "Receiving " & strLocalDir
                Case TRS_SUCCESS
                    stsStatusBar.Text = "Successful transfer"
                    Exit Do
                Case TRS_FAILURE
                    stsStatusBar.Text = "Transfer failed"
                    Exit Do
            End Select
        Loop



    End Sub

    Private Sub cmdSend_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSend.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("Text to send:")
        Session.Send(str_Renamed)
    End Sub

    Private Sub cmdSendFile_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSendFile.Click
        Dim strFile As String
        Dim strMsg As String
        Dim strTmp As String
        Dim intProtocol As Short

        ' Determine file to send
        strFile = InputBox("Full path of file to send:")

        ' Determine protocol
        strMsg = "1 = XMODEM" & vbCrLf & "3 = ZMODEM" & vbCrLf & "5 = XMODEM1K" & vbCrLf & vbCrLf & "Select a protocol:"
        strTmp = InputBox(strMsg)
        intProtocol = Val(strTmp)

        Call Session.SendFile(strFile, "", intProtocol, True)
        Do
            Select Case Session.GetTransferState
                Case TRS_NORMAL
                    stsStatusBar.Text = "Unable to transfer " & strFile
                Case TRS_SENDING
                    stsStatusBar.Text = "Sending " & strFile
                Case TRS_RECEIVING
                    stsStatusBar.Text = "Receiving " & strFile
                Case TRS_SUCCESS
                    stsStatusBar.Text = "Successful transfer"
                    Exit Do
                Case TRS_FAILURE
                    stsStatusBar.Text = "Transfer failed"
                    Exit Do
            End Select
        Loop

    End Sub

    Private Sub cmdSendKeystroke_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSendKeystroke.Click
        Dim strKey As String
        strKey = InputBox("Virtual Key to send:")
        Call Session.SendKeystroke(Val(strKey), False, False, False)
    End Sub

    Private Sub cmdSetBaudRate_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetBaudRate.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("Baud rate:")
        Session.SetBaudRate(Val(str_Renamed))
    End Sub

    Private Sub cmdSetCurrentPort_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetCurrentPort.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("Port name:")
        Session.SetCurrentPort(str_Renamed)
    End Sub

    Private Sub cmdSetFlowControl_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetFlowControl.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("1=DTRDSR" & vbCrLf & "2=CTSRTS" & vbCrLf & "4=XONXOFF" & vbCrLf & "Enter Value:")
        Session.SetFlowControl(Val(str_Renamed))
    End Sub

    Private Sub cmdSetFocus_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetFocus.Click
        Session.SetForegroundWindow()
    End Sub

    Private Sub cmdSetHost_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetHost.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("Host name:")
        Session.SetHost(str_Renamed)
    End Sub

    Private Sub cmdShow_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdShow.Click
        Session.ShowWindow(1)
    End Sub

    Private Sub cmdTest_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdTest.Click
        Session = Nothing
        Session = CreateObject("Alpha.Telnet")
        Session.NewSession()
        Session.ShowWindow(1)
        Session.SetHost("199.1.2.1")
        Session.Connect()

        ' Send username and password
        Call Session.WaitFor("", "ogin:", 3000, 0)
        Do
            If Session.WaitFound() Then
                Exit Do
            End If
            If Session.WaitTimeOut() Then
                stsStatusBar.Text = "timeout: did not find ogin:"
                Exit Sub
            End If
        Loop
        Call Session.WaitFor("colin\r", "assword:", 3000, 0)
        Do
            If Session.WaitFound() Then
                Exit Do
            End If
            If Session.WaitTimeOut() Then
                stsStatusBar.Text = "timeout: did not find assword:"
                Exit Sub
            End If
        Loop

        Call Session.WaitFor("cb8660143\r", "gbahome:/u/colin>", 3000, 0)
        Do
            If Session.WaitFound() Then
                Exit Do
            End If
            If Session.WaitTimeOut() Then
                stsStatusBar.Text = "timeout: did not find UNIX prompt:"
                Exit Sub
            End If
        Loop

        Session.Send("sz poo.txt\r")

    End Sub

    Private Sub cmdWait_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdWait.Click
        Dim strSend As String
        Dim strWaitFor As String
        strSend = InputBox("Text to send")
        strWaitFor = InputBox("Text to waitfor:")
        stsStatusBar.Text = "Waiting for " & strWaitFor
        Call Session.WaitFor(strSend, strWaitFor, 3000, 0)
        Do
            If Session.WaitFound() Then
                stsStatusBar.Text = "found " & strWaitFor
                Exit Do
            End If
            If Session.WaitTimeOut() Then
                stsStatusBar.Text = "timeout: did not find " & strWaitFor
                Exit Do
            End If
        Loop
    End Sub

    Private Sub frmAlphaDvr_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        'UPGRADE_NOTE: Object Session may not be destroyed until it is garbage collected. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6E35BFF6-CD74-4B09-9689-3E1A43DF8969"'
        Session = Nothing
    End Sub


    Private Sub SetTele_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles SetTele.Click
        'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
        Dim str_Renamed As String
        str_Renamed = InputBox("Enter telephone number:")
        Session.SetDial(str_Renamed)
    End Sub
End Class